from database import database_request
import pandas as pd
from identifier import names_list, is_kazakh_language

"""
    будет две даты:
    1. дата начало создание поста в базе
    2. дата окончание создание поста в базе

    например статистика за весь АВГУСТ
"""
date_start = '2021-08-01'
date_end = '2021-09-01'


"""
    отправляем даты в функцию для получения данных с базы в виде dataframe
"""
df = database_request(date_start, date_end)

### 1 что нужно отобразить в интерфейсе
print("общее количество постов: ", len(df))


df.drop_duplicates(subset='post_group_id', inplace=True)

### 2 что нужно отобразить в интерфейсе количество уникальных постов полученные по post_group_id
print("уникальных постов:", len(df))

### 3 что нужно отобразить в интерфейсе количество неразмеченных постов
print("неразмеченных постов со статусом '-1':", len(df[df['status'] == -1]))


df['exist'] = df['author_url'].apply(lambda x : True if x.lower() in names_list else False)

### 4 что нужно отобразить в интерфейсе количество постов написанные ЛОМами
print("общее количество постов от ЛОМов", len(df[df['exist'] == True]))

### 5 что нужно отобразить в интерфейсе количество постов от ЛОМов которые были размечены
print("посты от ЛОМов без статуса '-1':", len(df[(df['exist'] == True) & (df['status'] != -1)]))


df = df[df['exist'] == False]
df['characteristics'] = df['characteristics'].astype('str')
df['lang'] = df['text'].apply(lambda x : is_kazakh_language(x))

### 6 что нужно отобразить в интерфейсе количество постов на русском языке
print("посты на русском языке:", len(df[df['lang'] == False]))

### 7 что нужно отобразить в интерфейсе  количество НЕразмеченных постов на русском языке
print("количество постов на русском языке со статусом '-1'", len(df[(df['lang'] == False) & (df['status'] == -1)]))

### 8 что нужно отобразить в интерфейсе количество постов на  казахском языке
print("посты на казахском языке:", len(df[df['lang'] == True]))

### 9 что нужно отобразить в интерфейсе количество НЕразмеченных постов на  казахском языке
print("количество постов на казахском языке со статусом '-1'", len(df[(df['lang'] == True) & (df['status'] == -1)]))

df_ru = df[(df['lang'] == False) & (df['status'] != -1)]
df_kz = df[(df['lang'] == True) & (df['status'] != -1)]

### 10 что нужно отобразить в интерфейсе размеченные посты сгруппированные по характеристикам на русском языке
print("посты на русском по характеристике", "\n", df_ru.groupby("characteristics").count())

### 11 что нужно отобразить в интерфейсе размеченные посты сгруппированные по статусам на русском языке
print("посты на русском по статусу", "\n", df_ru.groupby("status").count())

### 12 что нужно отобразить в интерфейсе размеченные посты сгруппированные по характеристикам на казахском языке
print("посты на казахском по характеристике", "\n", df_kz.groupby("characteristics").count())

### 13 что нужно отобразить в интерфейсе размеченные посты сгруппированные по статусам на казахском языке
print("посты на казахском по статусу", "\n", df_kz.groupby("status").count())