names_list = open("complainant_list.txt", "r").read().splitlines()

def is_kazakh_language(text: list) -> bool:
        kaz_translit_words = """жагдай, кайырлы, деп, мен, ол, деген, менин, сол, керек, 
            болып, жане, жауап, жумыс, неге, жок, маган, емес, барып, ушин, шара, акша, сагат, жыл, жок, отыр, екен, бирак, 
            арыз, жайлы, шагым, емес, калай, куни, ауыр, ешкандай, жатыр, салеметсизбе, саламатсызба, салеметсиздерме, 
            саламатсыздарма, саламатсыз ба, салеметсиз бе, калай, кашан, бир, жылы, жумыс, гана, кызмет, сайын, дейн, шейн, 
            немесе, негизи, кайта, сиз, бир, еки, уш, алты, жети, сегиз, тогыз, жуз, мын, окиниш, окинишке, орай, сойлемеш, 
            жылы, шара, керек, бирак, кайырлы, болып, кайта, кашан, кызмет, жайлы, гана, орай, мен, сол, ушин, жане, неге,
            таяк, жакта, журсын, бершы, кошеде, отыр, уйде, коріп, койып, мына, бармайсын, уйыхтайсын, кирсей"""

        kaz_translit_words = set(kaz_translit_words.split(', '))
        set_of_words = set(text)
        count_of_translit_words = len(set_of_words.intersection(kaz_translit_words))
        count_of_native_words, _ = _get_number_of_kz_words(text=text, threshold=0)
        threshold_of_kz_words = 0.15 * len(set_of_words)
        return threshold_of_kz_words < count_of_translit_words or count_of_native_words > threshold_of_kz_words



def _get_number_of_kz_words(text: list, threshold=0) -> tuple:
        """
            detect words with kazakh symbols
            Keywords arguments :
            text -- input text
            threshold -- the minimum number of kz symbols in word
            return number of words with kazakh words
        """
        kz_symbols = 'әіңғүұқөһ'
        words_with_kz = [word for word in text if len(set(word).intersection(set(kz_symbols))) > threshold]
        return len(words_with_kz), words_with_kz