import csv
import pysolr

solr = pysolr.Solr('http://10.30.10.204:8984/solr/client2020_3/', timeout=10)

r = solr.search("*:*",
            **{'fq':
                 ["topic_id:6abbdb3f-a383-45c1-8000-2fe2c4beded5",
                  "-media_type:social",
                  "status:active",
                  "-verification_status:(nonrelevant OR duplicate OR old OR deleted)",
                  "date: [2020-05-01T00:00:00Z TO 2020-06-01T00:00:00Z]"],
             'facet': "on",
             'facet.field':"domain", 'facet.limit': -1})


domains = sorted(filter(lambda x: x[1] != 0, zip(r.facets['facet_fields']['domain'][::2],
                                                 r.facets['facet_fields']['domain'][1::2])), key=lambda x: -x[1])

f = open('/home/user/PycharmProjects/reports-by-analyst-request/out5.csv', 'w')

wtr = csv.writer(f, delimiter=',', lineterminator='\n')

wtr.writerows(domains)
