from __future__ import print_function
import time
import pysolr


def delete(**queries):
    query = []
    for key, value in queries.items():
        q = key + ":\"" + value + "\""
        query.append(q)

    query = " AND ".join(query)
    print("query=[{}]".format(query))

    results = solr.search(q=query)
    cnt=results.hits
    print("numFound: {}".format(cnt))
    if cnt>1500:
        print("numFound>1500. This process can stop solr or will become another not good results. \nPlease split request with date filter.")
        return
    elif cnt==0:
        print("numFound=0. Nothing to delete!")
        return
    print("deleting")
    solr.delete(q=query, commit=False)
    print("Deleted!")


if __name__ == '__main__':
    """
    delete(key1="value1", key2="value2")
    
    Для запросов hits(numFound)>1000 лучше не использовать, а то солр упадет или замедлить работу других сервисов
     
    Для таких запросов можно использовать временные дележки, например:
    delete(topic_id="...", abc="...", date="[\"2020-09-01T00:00:00Z\" TO \"2020-10-01T00:00:00Z\"]")
    
    Для проверки солько hits, для начало нужно проверить в солре
    
    Удаляет все подходящие посты по запросу
    
    В параметры можно передать любое поле(signature, domain, profile_url, etc.)
    """
    solr = pysolr.Solr('http://10.30.10.204:8984/solr/client2020_3/', always_commit=True)
    solr.ping()
    print("Connected")

    delete(topic_id="145", id="54598qwef", domain="skadjnv5768")
