from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy import Column, DateTime, String, ARRAY, Float, Boolean, Integer
from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from sqlalchemy.dialects.postgresql import UUID


base = declarative_base()

def create_session(username, password, host, db_name, port=None, table_name=None):
    port = port or 5432
    db = create_engine(f"postgresql://{username}:{password}@{host}:{port}/{db_name}")
    Session = sessionmaker(db)
    return Session()


def table_class(table_name):
    class Cluster_db(base):
        __tablename__ = table_name

        cluster_id = Column(UUID(as_uuid=True), primary_key=True, index=True)
        centroid = Column(ARRAY(Float))
        created_date = Column(DateTime)
        last_update_date = Column(DateTime)
        modified = Column(Boolean, index=True)
        is_actual = Column(Boolean, index=True)
        language = Column(String(16000))
        count = Column(Integer)

    return Cluster_db
# base.metadata.create_all(db)
